<?php
/*
======================
 Page Header Settings
======================
*/
Redux::setSection( $opt_name, array(
            'title'  => esc_html__( 'Page Header Settings', 'vankine' ),
            'id'     => 'page_header_settings_option',
            'desc'   => esc_html__( '', 'vankine' ),
            'icon'   => 'el el el-website',
            'fields' => array(
              
            array(
                'id'       => 'page_header_enable',
                'type'     => 'switch', 
                'title'    => __('Page Header Enable / Disable', 'vankine'),
                'default'  => true,
            ),
            
            array(
                'id'       => 'breadcrumb_enable',
                'type'     => 'switch', 
                'title'    => __('Breadcrumb Enable / Disable', 'vankine'),
                'default'  => true,
                'required' => array( 'page_header_enable', '=', true ),
            ),

            array(
                'id'       => 'page_header_alignment',
                'type'     => 'button_set',
                'title'    => __('Page Header Alignment', 'vankine'),
                'options' => array(
                    'left' => 'Left', 
                    'center' => 'Center', 
                    'right' => 'Right'
                 ), 
                'default' => 'center'
            ),

 
            array(
                'id'       => 'page_header_bg_image',
                'type'     => 'media', 
                'url'      => true,
                'title'    => __('Page header Background Image', 'vankine'),
              
            ),
            array(
                'id'       => 'blog_page_header_bg_image',
                'type'     => 'media', 
                'url'      => true,
                'title'    => __('Blog Page header Background Image', 'vankine'),
             
            ),
             
            array(
                'id'       => 'pageheader_bg_color',
                'type'     => 'color',
                'title'    => __('Page Header Background Color', 'vankine'), 
                'validate' => 'color',
               
            ),
            array(
                'id'       => 'page_header_padding',
                'type'     => 'text',
                'title'    => __('Page Header Padding', 'vankine'),
                'placeholder'    => __('5rem 0px 5rem 0px', 'vankine'),
                'default'  => '',
          
            ),

            array(
                'id'       => 'pageheader_title_color',
                'type'     => 'color',
                'title'    => __('Page Header Title Color', 'vankine'), 
                'validate' => 'color',
              
            ),
            array(
                'id'       => 'pageheader_breadcrumb_color',
                'type'     => 'color',
                'title'    => __('Page Header Breadcrumb Color', 'vankine'), 
                'validate' => 'color',
               
            ),
            
            array(
                'id'       => 'pageheader_breadcrumb_arrow_color',
                'type'     => 'color',
                'title'    => __('Page Header Breadcrumb Arrow Color', 'vankine'), 
                'validate' => 'color',
            ),
 

        )
));

