<?php
/*
** ============================== 
** Vankine Header Source File
** ==============================
*/

add_action('vankine_custom_search_setup',  'vankine_simple_search'); 
add_filter('get_the_archive_title', 'vankine_the_archive_title'); 
/*
** ==============================  
**  vankine_the_archive_title
** ============================== 
*/
function vankine_the_archive_title($title){
    global $vankine_theme_mod;
if(is_search()):
    $title = sprintf(esc_html__('Search Results', 'vankine'));
    elseif(is_404()):
        $title = sprintf(esc_html__('Page Not Found', 'vankine'));
    elseif(is_page()):
        $title = get_the_title();
    elseif(is_single()):
        $title = get_the_title();
    elseif (is_home() && is_front_page()):
        $title = esc_html__('The Latest Posts', 'vankine');
    elseif (is_home() && !is_front_page()):
        $title = get_the_title(get_option('page_for_posts'));
    elseif(is_singular('product')):
        $title = get_the_title(get_the_ID());
    elseif(is_tax() || is_category()  || is_tag()):
        $title = single_term_title('', false);
    elseif(is_singular('post')):
        $title = get_the_title(get_the_ID());
    elseif(is_singular('service')):
        $title = get_the_title(get_the_ID());
    elseif(is_singular('portfolio')):
        $title = get_the_title(get_the_ID());
    elseif(function_exists( 'dokan_is_store_page' ) && dokan_is_store_page()):
        $store_user   = dokan()->vendor->get( get_query_var( 'author' ) );
        $title = $store_user->get_shop_name();
    elseif(function_exists( 'wcfm_is_store_page' ) && wcfm_is_store_page()):
        $store_user = wcfmmp_get_store( get_query_var( 'author' ) );
        $store_info = $store_user->get_shop_info(); 
        $title = $store_info['store_name'];
    elseif(is_post_type_archive('product')):
        if(!empty($vankine_theme_mod['product_page_name'])):
            $title = $vankine_theme_mod['product_page_name'];
        else:
            $title = esc_html__('Product',  'vankine');
    endif;
endif;
return $title;
}
/*
** ============================== 
**  Simple Serch
** ============================== 
*/
function vankine_simple_search() { ?>
<form role="search" method="get" action="<?php echo esc_url(home_url( '/' )); ?>">
    <input type="search" class="search" placeholder="<?php echo esc_attr__( 'Search...', 'vankine' ); ?>"
        value="<?php echo get_search_query() ?>" name="s" title="Search" />
    <button type="submit" class="sch_btn"> <i class="fa fa-search"></i></button>
</form>
<?php 
} 