<?php

namespace  Vankineaddons\Core\Widgets\Header;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Side_menu_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-side-header-v1';
    }

    public function get_title()
    {
        return __('Side Header V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['100'];
    }

    protected function register_controls(){
        $this->start_controls_section('sideheaders_settings',
        [ 
            'label' => __('Side Menu Settings', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
 
        $this->add_control(
            'menu_text',
            [
                'label' => __( 'Menu Text', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Menu', 'vankine-addons' ),
                'placeholder' => __( 'Type your title here', 'vankine-addons' ),
            ]
        );
        $this->add_control(
            'hr_sevens',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );

     
        $this->add_control(
            'search_enable',
            [
                'label' => __('Search show / hide', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'hr_five',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'option_panel_enable',
            [
                'label' => __('Option Panel Show / Hide', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'hr_six',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'media_enable',
            [
                'label' => __('Media show / hide', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
    
        $repeater = new \Elementor\Repeater();
      
        $repeater->add_control(
            'social_media_icon',
            [
                'label' => __( 'Social Media Icon', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'fa fa-facebook', 'vankine-addons' ),
                'placeholder' => __( 'Type your Socail Media Icon Class Name', 'vankine-addons' ),
            ]
        );
        $repeater->add_control(
            'socail_media_link',
            [
                'label' => __( 'Link', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'vankine-addons' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );
        $this->add_control(
            'social_media_repeater',
            [
                'label' => __('Social Media Content', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                       'social_media_icon' =>  __('fa fa-facebook', 'vankine-addons'),
                       'socail_media_link' =>  __('#', 'vankine-addons'),
                    ],
                    [
                       'social_media_icon' =>  __('fa fa-twitter', 'vankine-addons'),
                       'socail_media_link' =>  __('#', 'vankine-addons'),
                     ],
                     [
                        'social_media_icon' =>  __('fa fa-skype', 'vankine-addons'),
                        'socail_media_link' =>  __('#', 'vankine-addons'),
                     ],
                     [
                        'social_media_icon' =>  __('fa fa-telegram', 'vankine-addons'),
                        'socail_media_link' =>  __('#', 'vankine-addons'),
                     ],
                ],
                'title_field' => '{{{ social_media_icon }}}',
                'condition' => [
                    'media_enable' => 'yes'
                ],
            ]
        );
    
        $this->add_control(
            'hr_five_f',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );
        $this->add_control(
            'button_enable',
            [
                'label' => __('Button show / hide', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'button_texts',
            [
                'label' => __( 'Button Text', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Get A Quote', 'vankine-addons' ),
                'placeholder' => __( 'Type your title here', 'vankine-addons' ),
                'condition' => [
                    'button_enable' => 'yes'
                ],
            ]
        );
        
        
        $this->add_control(
            'button_link',
            [
                'label' => __( 'Button Link', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'vankine-addons' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'condition' => [
                    'button_enable' => 'yes'
                ],
            ]
        );

      
        $this->end_controls_section();
 
        $this->start_controls_section('sideheaders_two_settings',
        [ 
            'label' => __('Side Menu Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );

        $this->add_control(
            'navigations',
            [
                'label' => __('Select Navigation', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => vankine_navmenu(),
            ]
        );

        $this->add_control(
            'hr_seven',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
            ]
        );

        $this->add_control(
            'logo_default',
        [
            'label' => __( 'Logo Default', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::MEDIA,
            'default' => [
            'url' => VANKINE_ADDONS_URL . '/assets/imgs/logo-white.svg',
            ],
        ] 
        );


        $this->add_control(
        'logo_width',
        [
            'label' => __( 'Logo Width', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => __( '170px', 'vankine-addons' ),
            'placeholder' => __( 'Enter logo width here in (px , rem and em )', 'vankine-addons' ),
            'selectors' => [
                '{{WRAPPER}} .header .header_logo_box img' => 'width: {{VALUE}}!important;',
            ],
        ]
        );
        $this->add_control(
            'margin_logo',
            [
                'label' => __( 'Margin', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .header .header_logo_box img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'custom_link_enable',
            [
                'label' => __('Custom Link show / hide', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'vankine-addons'),
                'label_off' => __('No', 'vankine-addons'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );


        $this->add_control(
            'logo_link',
            [
                'label' => __( 'Link', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __( 'https://your-link.com', 'vankine-addons' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
                'condition' => [
                    'custom_link_enable' => 'yes'
                ],
            ]
        );

        $this->add_control(
            'hr_five_sev',
            [
                'type' => \Elementor\Controls_Manager::DIVIDER,
            ]
        );

        $this->add_control(
            'contact_form_title',
            [
                'label' => __( 'Title', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'Need Any Help?  Or Looking For  an Agent', 'vankine-addons' ),
                'placeholder' => __( 'Type your title here', 'vankine-addons' ),
                'condition' => [
                    'button_enable' => 'yes'
                ],
            ]
        );
        $this->add_control(
            'contact_form_descriprion',
            [
                'label' => __( 'Description', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __( 'On the other hand denounce righteousy indignation and dislike men', 'vankine-addons' ),
                'placeholder' => __( 'Type your title here', 'vankine-addons' ),
                'condition' => [
                    'button_enable' => 'yes'
                ],
            ]
        );
 

        $this->add_control(
            'forms_plu',
            [
            'label' => __('Contact Form Plugin type', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'wpforms' => __( 'Wp Forms', 'vankine-addons' ),
                'contactformseven' => __( 'Contact Form 7', 'vankine-addons' ),
            ],
            'default' => 'wpforms' , 
            
            ]
        );

        $this->add_control(
            'contact_form_url',
            [
                'label'   => esc_html__( 'Choose Contact Form', 'vankine-addons' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
               'options' =>  vankine_contact_form_7_query('wpforms'),
               'condition' => [
                'forms_plu' => 'wpforms',
                ],
            ]
        );

        
        $this->add_control(
            'contact_form_url_seven',
            [
                'label'   => esc_html__( 'Choose Contact Form', 'vankine-addons' ),
                'type'    => \Elementor\Controls_Manager::SELECT,
               'options' =>  vankine_contact_form_7_query('wpcf7_contact_form'),
               'condition' => [
                'forms_plu' => 'contactformseven',
                ],
            ]
        );

        $this->end_controls_section(); 
        
        $this->start_controls_section('sidemenu_css',
        [ 
            'label' => __('Custom Css', 'vankine-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]);

      
        $this->add_control(
            'side_menu_bg',
            [
                'label' => __('Side Header Bg Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .side_menu_v1 ' => 'background: {{VALUE}}!important;',
                ],
            ]
        ); 

        $this->add_control(
            'menu_btnicolor',
            [
                'label' => __('Menu Btn Icon Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .side_menu_v1 .side_navbar_togglers svg path' => 'fill: {{VALUE}}!important;',
                ],
            ]
        ); 
        $this->add_control(
            'menu_btntcolor',
            [
                'label' => __('Menu Btn Text Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .side_menu_v1 .side_navbar_togglers span ' => 'color: {{VALUE}}!important;',
                ],
            ]
        ); 


        $this->add_control(
            'icon_color',
             [
                'label' => __('Search Icon Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .side_menu_v1 .search i ' => 'color: {{VALUE}}!important;',
                ],
                'condition' => [
                    'search_enable' => 'yes'
                ],
             ]
        ); 
        
        $this->add_control(
            'icon_color_two',
             [
                'label' => __('Option Panel Icon Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .side_menu_v1  .contact-toggler svg path' => 'stroke: {{VALUE}}!important;',
                ],
                'condition' => [
                    'option_panel_enable' => 'yes'
                ],
             ]
        ); 
        
        $this->add_control(
            'icon_bg_color',
             [
                'label' => __('Option / Search Icon Border Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .side_menu_v1 .search , {{WRAPPER}} .side_menu_v1  .contact-toggler ' => 'border-color: {{VALUE}}!important;',
                ],
             ]
        ); 



        $this->add_control(
            'color_one',
            [
                'label' => __( 'Media Icon Color', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .side_menu_v1 .social-icons ul li .m_icon ' => 'color: {{VALUE}}',
                ],
            ]
        );
    
        $this->add_control(
            'color_two',
            [
                'label' => __( 'Media Icon Bg Color', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .side_menu_v1 .social-icons ul li .m_icon ' => 'background: {{VALUE}}!important',
                ],
            ]
        );

        $this->add_control(
            'color_three',
            [
                'label' => __( 'Media Icon Hover Color', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .side_menu_v1 .social-icons ul li .m_icon:hover ' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_control(
            'color_four',
            [
                'label' => __( 'Media Icon Hover Bg Color', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .side_menu_v1 .social-icons ul li .m_icon:hover ' => 'background: {{VALUE}}!important',
                ],
            ]
        );


        
        $this->add_control(
            'button_border_color',
            [
                'label' => __( 'Button Boder Color', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .side_menu_v1 .button_box a ' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_control(
            'button_text_color',
            [
                'label' => __( 'Button Text Color', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .side_menu_v1 .button_box a ' => 'color: {{VALUE}}!important',
                    '{{WRAPPER}} .side_menu_v1 .button_box a svg path ' => 'fill: {{VALUE}}!important',
                ],
            ]
        );



        $this->end_controls_section();
        
        
        $this->start_controls_section('Panel_css',
        [ 
            'label' => __('Panel Css', 'vankine-addons'),
            'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
        ]);
 
        $this->add_control(
            'pcolor_one',
            [
                'label' => __( 'Media Icon Color', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .menu_open_sidely  .social-icons ul li .m_icon ' => 'color: {{VALUE}}',
                ],
            ]
        );
    
        $this->add_control(
            'pcolor_two',
            [
                'label' => __( 'Media Icon Bg Color', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .menu_open_sidely  .social-icons ul li .m_icon ' => 'background: {{VALUE}}!important',
                ],
            ]
        );

        $this->add_control(
            'pcolor_three',
            [
                'label' => __( 'Media Icon Hover Color', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .menu_open_sidely  .social-icons ul li .m_icon:hover ' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_control(
            'pcolor_four',
            [
                'label' => __( 'Media Icon Hover Bg Color', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .menu_open_sidely  .social-icons ul li .m_icon:hover ' => 'background: {{VALUE}}!important',
                ],
            ]
        );
 
        $this->end_controls_section(); 

} 
protected function render(){
$settings = $this->get_settings_for_display();
$allowed_tags = wp_kses_allowed_html('post');
$url = '';
if($settings['custom_link_enable'] == 'yes'):
$logo_target = $settings['logo_link']['is_external'] ? ' target="_blank"' : '';
$logo_nofollow = $settings['logo_link']['nofollow'] ? ' rel="nofollow"' : ''; 
    $url = $settings['logo_link']['url'];
else:
    $url = home_url();
endif;
?>

<div class="side_menu_v1">

    <div class="top">
        <div class="menu_box">
            <div class="side_navbar_togglers">
                <svg width="38" height="25" viewBox="0 0 38 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd"
                        d="M0 1.5625C0 1.1481 0.16462 0.750671 0.457645 0.457645C0.750671 0.16462 1.1481 0 1.5625 0H31.9375C32.3519 0 32.7493 0.16462 33.0424 0.457645C33.3354 0.750671 33.5 1.1481 33.5 1.5625C33.5 1.9769 33.3354 2.37433 33.0424 2.66735C32.7493 2.96038 32.3519 3.125 31.9375 3.125H1.5625C1.1481 3.125 0.750671 2.96038 0.457645 2.66735C0.16462 2.37433 0 1.9769 0 1.5625ZM0 12.5C0 12.0856 0.16462 11.6882 0.457645 11.3951C0.750671 11.1021 1.1481 10.9375 1.5625 10.9375H35.9375C36.3519 10.9375 36.7493 11.1021 37.0424 11.3951C37.3354 11.6882 37.5 12.0856 37.5 12.5C37.5 12.9144 37.3354 13.3118 37.0424 13.6049C36.7493 13.8979 36.3519 14.0625 35.9375 14.0625H1.5625C1.1481 14.0625 0.750671 13.8979 0.457645 13.6049C0.16462 13.3118 0 12.9144 0 12.5ZM0 23.4375C0 23.0231 0.16462 22.6257 0.457645 22.3326C0.750671 22.0396 1.1481 21.875 1.5625 21.875H25.9375C26.3519 21.875 26.7493 22.0396 27.0424 22.3326C27.3354 22.6257 27.5 23.0231 27.5 23.4375C27.5 23.8519 27.3354 24.2493 27.0424 24.5424C26.7493 24.8354 26.3519 25 25.9375 25H1.5625C1.1481 25 0.750671 24.8354 0.457645 24.5424C0.16462 24.2493 0 23.8519 0 23.4375Z"
                        fill="#138F82" />
                </svg>

                <span><?php echo esc_attr($settings['menu_text']); ?></span>
            </div>
           
        </div>
        <?php if($settings['search_enable'] == 'yes'): ?>
        <div class="search_box">
            <div class="search search-toggler">
                <i class="fi-rs-search"></i>
            </div>
        </div>
        <?php endif;?>
        <?php if($settings['option_panel_enable'] == 'yes'): ?>
        <div class="contacttoggler">
            <div class="contact-toggler">
                <svg width="18" height="19" viewBox="0 0 18 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M0.75 3.25C0.75 2.65326 0.987053 2.08097 1.40901 1.65901C1.83097 1.23705 2.40326 1 3 1H5.25C5.84674 1 6.41903 1.23705 6.84099 1.65901C7.26295 2.08097 7.5 2.65326 7.5 3.25V5.5C7.5 6.09674 7.26295 6.66903 6.84099 7.09099C6.41903 7.51295 5.84674 7.75 5.25 7.75H3C2.40326 7.75 1.83097 7.51295 1.40901 7.09099C0.987053 6.66903 0.75 6.09674 0.75 5.5V3.25ZM0.75 13C0.75 12.4033 0.987053 11.831 1.40901 11.409C1.83097 10.9871 2.40326 10.75 3 10.75H5.25C5.84674 10.75 6.41903 10.9871 6.84099 11.409C7.26295 11.831 7.5 12.4033 7.5 13V15.25C7.5 15.8467 7.26295 16.419 6.84099 16.841C6.41903 17.2629 5.84674 17.5 5.25 17.5H3C2.40326 17.5 1.83097 17.2629 1.40901 16.841C0.987053 16.419 0.75 15.8467 0.75 15.25V13ZM10.5 3.25C10.5 2.65326 10.7371 2.08097 11.159 1.65901C11.581 1.23705 12.1533 1 12.75 1H15C15.5967 1 16.169 1.23705 16.591 1.65901C17.0129 2.08097 17.25 2.65326 17.25 3.25V5.5C17.25 6.09674 17.0129 6.66903 16.591 7.09099C16.169 7.51295 15.5967 7.75 15 7.75H12.75C12.1533 7.75 11.581 7.51295 11.159 7.09099C10.7371 6.66903 10.5 6.09674 10.5 5.5V3.25ZM10.5 13C10.5 12.4033 10.7371 11.831 11.159 11.409C11.581 10.9871 12.1533 10.75 12.75 10.75H15C15.5967 10.75 16.169 10.9871 16.591 11.409C17.0129 11.831 17.25 12.4033 17.25 13V15.25C17.25 15.8467 17.0129 16.419 16.591 16.841C16.169 17.2629 15.5967 17.5 15 17.5H12.75C12.1533 17.5 11.581 17.2629 11.159 16.841C10.7371 16.419 10.5 15.8467 10.5 15.25V13Z"
                        stroke="#0F3567" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                </svg>


            </div>
        </div>
        <?php endif;?>
    </div>



    <?php if($settings['media_enable'] == 'yes'): ?>
    <div class="social-icons">
        <ul class="d-inline-block">
            <?php foreach($settings['social_media_repeater'] as $media_repearter):?>
            <?php $target = $media_repearter['socail_media_link']['is_external'] ? ' target="_blank"' : '';
                                $nofollow = $media_repearter['socail_media_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
            <li>
                <a class="m_icon" href="<?php echo esc_url($media_repearter['socail_media_link']['url']); ?>"
                    <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                    <i class="<?php echo esc_attr($media_repearter['social_media_icon']); ?>"></i>
                </a>
            </li>
            <?php endforeach;?>
        </ul>
    </div>
    <?php endif; ?>
    <div class="button_box">
        <div class="button">
            <?php $target = $settings['button_link']['is_external'] ? ' target="_blank"' : '';
                        $nofollow = $settings['button_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
            <a href="<?php echo esc_url($settings['button_link']['url']); ?>" <?php echo esc_attr($target); ?>
                <?php echo esc_attr($nofollow); ?>>
                <span class="vertical_text_1"><?php echo esc_attr($settings['button_texts']); ?></span>
                <svg width="8" height="41" viewBox="0 0 8 41" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path
                        d="M3.64644 40.3536C3.84171 40.5488 4.15829 40.5488 4.35355 40.3536L7.53553 37.1716C7.73079 36.9763 7.73079 36.6597 7.53553 36.4645C7.34027 36.2692 7.02369 36.2692 6.82843 36.4645L4 39.2929L1.17157 36.4645C0.976309 36.2692 0.659727 36.2692 0.464465 36.4645C0.269202 36.6597 0.269202 36.9763 0.464464 37.1716L3.64644 40.3536ZM3.5 -2.18557e-08L3.5 40L4.5 40L4.5 2.18557e-08L3.5 -2.18557e-08Z"
                        fill="#138F82" />
                </svg>

            </a>
        </div>
    </div>

</div>
<div class="sdmenu_overlay"></div>
<div class="menu_open_sidely scrollbarcolor">
<div class="border_line"></div>
    <div class="position-relative">
    <div class="large-container">
     
                <div class="side_navbar_togglers_close">
                    <i class="fa fa-close"></i>
                </div>
         
        <div class="row">
            <div class="col-lg-3 col-md-3 col-sm-12">
            <a href="<?php echo esc_url($url); ?>" class="logo navbar-brand"
                    <?php if($settings['custom_link_enable'] == 'yes'): echo esc_attr($logo_target);  echo esc_attr($logo_nofollow); endif; ?>>
                    <img src="<?php echo esc_url($settings['logo_default']['url']); ?>"
                        alt="<?php echo esc_html(get_bloginfo( 'name' )); ?>" class="logo_default">
                </a>
                <div class="menu_content_in">
                    <div class="navbar_content d-flex align-items-center">
                        <?php if(!empty($settings['navigations'])):
                            wp_nav_menu(array(
                                'menu' => $settings['navigations'],
                                'container' => false,
                                'menu_class' => 'navbar_nav',
                                'fallback_cb'    => 'Vankine_WP_Bootstrap_Navwalker::fallback',
                                'walker' => new \Vankine_WP_Bootstrap_Navwalker()
                            )); 
                        endif; ?>

                    </div>
                </div>
            </div>
           
            <div class="col-lg-3 col-md-3 col-sm-12">
            </div>
            <div class="col-lg-5 col-md-5 col-sm-12">
                <div class="form_box">
                    <h2><?php echo wp_kses($settings['contact_form_title'] , $allowed_tags); ?></h2>
                    <div class="contact_form_shortcode">
                    <?php if($settings['forms_plu'] == 'wpforms'): ?>
                        <?php if(!empty($settings['contact_form_url'])): ?>
                            <?php echo do_shortcode('[wpforms id="' . $settings['contact_form_url'] . '"]'); ?>
                        <?php else: ?>
                            <p><?php echo esc_html('There is no contact form please create it' , 'vankine-addons'); ?></p>
                        <?php endif; ?>
                        <?php elseif($settings['forms_plu'] == 'contactformseven'): ?>
                            <?php if(!empty($settings['contact_form_url_seven'])): ?>
                                <?php echo do_shortcode('[contact-form-7 id="' . $settings['contact_form_url_seven'] . '"]'); ?>
                            <?php else: ?>
                                <p><?php echo esc_html('There is no contact form please create it' , 'vankine-addons'); ?></p>
                            <?php endif; ?>
                        <?php endif; ?>                 
                    </div>
                    <p><?php echo wp_kses($settings['contact_form_descriprion'] , $allowed_tags); ?></p>
                    <?php if($settings['media_enable'] == 'yes'): ?>
                    <div class="social-icons">
                        <ul class="d-inline-block">
                            <?php foreach($settings['social_media_repeater'] as $media_repearter):?>
                            <?php $target = $media_repearter['socail_media_link']['is_external'] ? ' target="_blank"' : '';
                                $nofollow = $media_repearter['socail_media_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
                            <li>
                                <a class="m_icon"
                                    href="<?php echo esc_url($media_repearter['socail_media_link']['url']); ?>"
                                    <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                                    <i class="<?php echo esc_attr($media_repearter['social_media_icon']); ?>"></i>
                                </a>
                            </li>
                            <?php endforeach;?>
                        </ul>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
            <div class="col-lg-1 col-md-1 col-sm-12">
            </div>
        </div>
    </div>
    </div>
</div>


<?php
    }
}