<?php

namespace  Vankineaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class Theme_btn_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-themebtns-v1';
    }

    public function get_title()
    {
        return __('Theme Buttons V1' , 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['101'];
    }

    

    protected function register_controls()
    {

         

        $this->start_controls_section(
            'theme_btn_content',
            [
                'label' => __('theme Button Content', 'vankine-addons')
            ]
        );

        $this->add_control(
            'theme_btn_styles',
            [
                'label' => __('theme Button Styles', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'style_one' => __( 'Style One', 'vankine-addons' ),
                    'style_two' => __( 'Style Two', 'vankine-addons' ),
                
				],
                'default' => 'style_one' , 
            ]
        );

        $this->add_responsive_control(
            'icon_alignment',
            [
                'label' => __('Icon Position', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                  'ileft' => [
                    'title' => __( 'Left', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-left',
                  ],
                  'iright' => [
                    'title' => __( 'Right', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-right',
                  ],
                ],
                'default' => 'iright',
                'toggle' => true,
            ]
        );
  

        $this->add_responsive_control(
          'btn_alignments',
          [
              'label' => __('Button alignments', 'vankine-addons'),
              'type' => \Elementor\Controls_Manager::CHOOSE,
              'options' => [
                'left' => [
                  'title' => __( 'Text Left', 'vankine-addons' ),
                  'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                  'title' => __( 'Text Center', 'vankine-addons' ),
                  'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                  'title' => __( 'Text Right', 'vankine-addons' ),
                  'icon' => 'eicon-text-align-right',
                ],
              ],
              'default' => 'right',
              'toggle' => true,
              'selectors' => [
                '{{WRAPPER}} .theme_btn_all' => 'text-align: {{VALUE}}!important;',
              ],
          ]
      );

      $this->add_control(
        'switcher_c_icon',
        [
            'label' => esc_html__( 'Use Custom Icon', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__( 'Yes', 'vankine-addons' ),
            'label_off' => esc_html__( 'No', 'vankine-addons' ),
            'return_value' => 'yes',
            'default' => '',
        ]
    );
    
    $this->add_control(
        'icon',
        [
            'label' => __('Icon', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::SELECT2,
            'options' => vankine_get_icon(),
            'default' => 'fi-rs-user' , 
            'condition' => [
                'switcher_c_icon' => 'yes' ,
            ]
        ]
    );
    $this->add_control(
        'icon_lib',
        [
            'label' => __('Icon', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::ICONS,
            'default' => [
                'value' => 'fab fa-facebook-f',
                'library' => 'fa-brands',
            ],
            'label_block' => true,
            'condition' => [
                'switcher_c_icon' => '',
            ]
        ]
    );
  
        $this->add_control(
			'button_text',
			[
				'label'       => esc_html__( 'Button Text', 'vankine-addons' ),
				'type'        => \Elementor\Controls_Manager::TEXT,
                'default' =>  esc_html__( 'Contact us' , 'vankine-addons'),
		]);

        $this->add_control(
            'button_link',
        [
            'label' => __('Theme Link', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::URL,
            'placeholder' => __('https://your-link.com', 'vankine-addons'),
            'show_external' => true,
            'default' => [
                'url' => '#',
                'is_external' => true,
                'nofollow' => true,
            ],
        ]
        );  


        $this->add_responsive_control(
            'iconnumber',
            [
                'label' => __('Icon Font Size', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min'     => 1,
                'max'     => 500,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .theme_btn i  ' => 'font-size: {{VALUE}}px!important;', 
                    '{{WRAPPER}} .theme_btn svg  ' => 'width: {{VALUE}}px!important;', 
                ],
            ]
        );
        $this->add_responsive_control(
            'iconrotate',
            [
                'label' => __('Icon Rotate', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '0',
                'min'     => -360,
                'max'     => 360,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .theme_btn i  ' => 'transform: rotate({{VALUE}}deg)!important;', 
                    '{{WRAPPER}} .theme_btn svg  ' => 'transform: rotate({{VALUE}}deg)!important;', 
                ],
            ]
        );
        $this->add_responsive_control(
            'icon_left',
             [
                'label' => __('Icon Move Left', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '0',
                'min'     => -100,
                'max'     => 110,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn i , {{WRAPPER}} .theme_btn_all svg' => 'left: {{VALUE}}px!important;',
                ],
                'condition' => [
                    'icon_alignment' => 'ileft',
                ]
             ]
        );
        $this->add_responsive_control(
            'icon_top',
             [
                'label' => __('Icon Move Top', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '0',
                'min'     => -100,
                'max'     => 110,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn i , {{WRAPPER}} .theme_btn_all svg' => 'top: {{VALUE}}px!important;',
                ],
             ]
        );
        $this->add_responsive_control(
            'icon_right',
             [
                'label' => __('Icon Move Left', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '0',
                'min'     => -100,
                'max'     => 110,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn i , {{WRAPPER}} .theme_btn_all svg' => 'right: {{VALUE}}px!important;',
                ],
                'condition' => [
                    'icon_alignment' => 'iright',
                ]
             ]
        );
        $this->add_control(
            'icon_color',
             [
                'label' => __('Icon Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn i' => 'color: {{VALUE}}!important;',
                ],
             ]
          );
          $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Button Typography', 'vankine-addons' ),
                'name' => 'button_typo',
                'selector' => '{{WRAPPER}} .theme_btn',
            ]
        );
        $this->add_control(
            'button_color',
             [
                'label' => __('Button Text Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn ' => 'color: {{VALUE}}!important;',
                ],
             ]
          );
          
            $this->add_control(
            'bgh1s',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                ]
            );

           
        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background_color',
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .theme_btn ',
            ]
        );

        $this->add_control(
            'bgh2s',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                ]
            );
      
          $this->add_control(
            'border_color',
             [
                'label' => __('Button Border Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn ' => 'border-color: {{VALUE}}!important;',
                ],
             ]
          );
       
          $this->add_responsive_control(
                  'border_radius',
                  [
                      'label' => __( 'Border Radius', 'vankine-addons' ),
                      'type' => \Elementor\Controls_Manager::DIMENSIONS,
                      'size_units' => ['px'],
                      'selectors' => [
                          '{{WRAPPER}} .theme_btn   ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                      ],
                  ]
          );
          $this->add_responsive_control(
            'number',
            [
                'label' => __('Button With', 'vankine-addons'),
                'type'    => \Elementor\Controls_Manager::NUMBER,
                'default' => '',
                'min'     => 1,
                'max'     => 500,
                'step'    => 1,
                'selectors' => [
                    '{{WRAPPER}} .theme_btn  ' => 'min-width: {{VALUE}}px!important;', 
                ],
            ]
        );

          $this->add_responsive_control(
            'padding',
            [
                'label' => __( 'Padding', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'selectors' => [
                    '{{WRAPPER}} .theme_btn   ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
                ],
            ]
        );
        $this->add_control(
            'icon_hover_color',
             [
                'label' => __('Icon Hover Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn:hover i' => 'color: {{VALUE}}!important;',
                ],
             ]
          );
          $this->add_control(
            'button_color_hover',
             [
                'label' => __('Button Hover Text Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn:hover ' => 'color: {{VALUE}}!important;',
                ],
             ]
          );
          $this->add_control(
            'bgh1',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                ]
            );

           
            $this->add_group_control( 
                \Elementor\Group_Control_Background::get_type(),
                [
    
                    'name' => 'background_color_hover',
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .theme_btn:hover ',
                ]
            );

        $this->add_control(
            'bgh2',
                [
                'type' => \Elementor\Controls_Manager::DIVIDER, 
                ]
            );
      
        
      
          $this->add_control(
            'border_color_hover',
             [
                'label' => __('Button Hover Border Color', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .theme_btn:hover ' => 'border-color: {{VALUE}}!important;',
                ],
             ]
          );
 
     
        $this->end_controls_section();
 
      
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $allowed_tags = wp_kses_allowed_html('post');

?>
 <?php $target = $settings['button_link']['is_external'] ? ' target="_blank"' : '';
$nofollow = $settings['button_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
        <?php if($settings['theme_btn_styles'] == 'style_one'): ?>
        <div class="theme_btn_all">
            <a href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?> class="theme_btn">
            <?php if($settings['icon_alignment'] == 'ileft'): ?>
            <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                        <?php if(!empty($settings['icon'])): ?>
                            <span><i class="<?php echo esc_attr($settings['icon']); ?>"></i></span>
                        <?php endif; ?>	
                    <?php else: ?>
                        <?php if(!empty($settings['icon_lib'])): ?>
                            <span><?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?></span>
                        <?php endif; ?>	
                <?php endif; ?>	
            <?php endif; ?>	
              <?php echo esc_html($settings['button_text']);?>
              <?php if($settings['icon_alignment'] == 'iright'): ?>
              <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                        <?php if(!empty($settings['icon'])): ?>
                            <span> <i class="<?php echo esc_attr($settings['icon']); ?>"></i></span>
                        <?php endif; ?>	
                    <?php else: ?>
                        <?php if(!empty($settings['icon_lib'])): ?>
                            <span><?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?></span>
                        <?php endif; ?>	
                <?php endif; ?>	
                <?php endif; ?>	
            </a>
        </div>
        <?php elseif($settings['theme_btn_styles'] == 'style_two'): ?>
        <div class="theme_btn_all">
        <a class="show-all" href="<?php echo esc_url($settings['button_link']['url']);?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
        <?php if($settings['icon_alignment'] == 'ileft'): ?>
        <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                        <?php if(!empty($settings['icon'])): ?>
                            <span><i class="<?php echo esc_attr($settings['icon']); ?>"></i></span>
                        <?php endif; ?>	
                    <?php else: ?>
                        <?php if(!empty($settings['icon_lib'])): ?>
                            <span><?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?></span>
                        <?php endif; ?>	
                <?php endif; ?>	
                <?php endif; ?>	
            <?php echo esc_html($settings['button_text']);?>
            <?php if($settings['icon_alignment'] == 'iright'): ?>
              <?php if($settings['switcher_c_icon'] == 'yes'): ?>
                        <?php if(!empty($settings['icon'])): ?>
                            <span><i class="<?php echo esc_attr($settings['icon']); ?>"></i></span>
                        <?php endif; ?>	
                    <?php else: ?>
                        <?php if(!empty($settings['icon_lib'])): ?>
                            <span><?php \Elementor\Icons_Manager::render_icon($settings['icon_lib'], [ 'aria-hidden' => 'false' ]); ?></span>
                        <?php endif; ?>	
                <?php endif; ?>
                <?php endif; ?>	
        </a> 
        </div>
        <?php endif; ?>
<?php
    }
}

 