<?php

namespace  Vankineaddons\Core\Widgets\Content;

if (!defined('ABSPATH')) {
    exit;
} // If this file is called directly, abort.

class List_v1 extends \Elementor\Widget_Base
{

    public function get_name()
    {
        return 'vankine-list-items-v1';
    }

    public function get_title()
    {
        return __('List Items V1', 'vankine-addons');
    }

    public function get_icon()
    {
        return 'icon-vankine-icon';
    }

    public function get_categories()
    {
        return ['101'];
    }

    protected function register_controls(){
 
        // style one start
        $this->start_controls_section('list_v1_settings',
        [ 
            'label' => __('List Content', 'vankine-addons'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
        );
      
 
        $this->add_control(
          'list_type',
          [
          'label' => __('List Type', 'vankine-addons'),
          'type' => \Elementor\Controls_Manager::SELECT,
          'options' => [
              'linline' => __( 'Inline View', 'vankine-addons' ),
              'list' => __( 'List View', 'vankine-addons' ),
          ],
          'default' => 'list' , 
          ]
         
      );

        $repeater = new \Elementor\Repeater(); 

        $repeater->add_control(
			'icon_type',
			[
				'label' => esc_html__( 'Icon Type', 'vankine-addons' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'options' => [
					'image' => esc_html__( 'Image', 'vankine-addons' ),
					'icon'  => esc_html__( 'Icon', 'vankine-addons' ), 
				], 
                'default' => 'icon' , 
			]
		);
        $repeater->add_control(
            'image',
            [
                'label' => __( 'Image', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'icon_type' => 'image'
                ],
            ] 
        );
        $repeater->add_control(
            'switcher_c_icon',
            [
                'label' => esc_html__( 'Use Custom Icon', 'vankine-addons' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Yes', 'vankine-addons' ),
                'label_off' => esc_html__( 'No', 'vankine-addons' ),
                'return_value' => 'yes',
                'default' => '',
            ]
        );
        
        $repeater->add_control(
            'icon',
            [
                'label' => __('Icon', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => vankine_get_icon(),
                'default' => 'fi-rs-user' , 
                'condition' => [
                    'switcher_c_icon' => 'yes' ,
                ]
            ]
        );
        $repeater->add_control(
            'icon_lib',
            [
                'label' => __('Icon', 'vankine-addons'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'fa-brands',
                ],
                'label_block' => true,
                'condition' => [
                    'switcher_c_icon' => '',
                ]
            ]
        );
 
        $repeater->add_control(
          'list_item',
          [
             'label' => __('List item', 'vankine-addons'),
             'type' => \Elementor\Controls_Manager::TEXTAREA,
             'default' => __('Cake & Milk', 'vankine-addons'),
             'placeholder' => __('Type your text here', 'vankine-addons'),    
          ]
        );
        
        $repeater->add_control(
          'list_link',
          [
              'label' => __('Link', 'vankine-addons'),
              'type' => \Elementor\Controls_Manager::URL,
              'placeholder' => __('https://your-link.com', 'vankine-addons'),
              'show_external' => true,
              'default' => [
                  'url' => '#',
                  'is_external' => false,
                  'nofollow' => false,
              ],
          ]
      );
 

       $this->add_control(
        'list_repeater',
        [
            'label' => __('List Repeater', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
                [
                'icon_type' => __('icon', 'vankine-addons'),
                'icon'  =>  __('fi-rs-arrow-small-right', 'vankine-addons'),
                'list_item' =>  __('House Insurance', 'vankine-addons'),
                'list_link' =>  __('#', 'vankine-addons'),
                ],
                 [
                'icon_type' => __('icon', 'vankine-addons'),
                'icon'  =>  __('fi-rs-arrow-small-right', 'vankine-addons'),
                'list_item' =>  __(' Medical Insurance', 'vankine-addons'),
                'list_link' =>  __('#', 'vankine-addons'),
                ],
                 [
                'icon_type' => __('icon', 'vankine-addons'),
                'icon'  =>  __('fi-rs-arrow-small-right', 'vankine-addons'),
                'list_item' =>  __('Car Insurance', 'vankine-addons'),
                'list_link' =>  __('#', 'vankine-addons'),
                ],
                 [
                'icon_type' => __('icon', 'vankine-addons'),
                'icon'  =>  __('fi-rs-arrow-small-right', 'vankine-addons'),
                'list_item' =>  __('Business Insurance', 'vankine-addons'),
                'list_link' =>  __('#', 'vankine-addons'),
                ],
                 [
                'icon_type' => __('icon', 'vankine-addons'),
                'icon'  =>  __('fi-rs-arrow-small-right', 'vankine-addons'),
                'list_item' =>  __('Travel Insurance', 'vankine-addons'),
                'list_link' =>  __('#', 'vankine-addons'),
                ],
                [
                'icon_type' => __('icon', 'vankine-addons'),
                'icon'  =>  __('fi-rs-arrow-small-right', 'vankine-addons'),
                'list_item' =>  __('Fire Insurance', 'vankine-addons'),
                'list_link' =>  __('#', 'vankine-addons'),
                ],
                [
                'icon_type' => __('icon', 'vankine-addons'),
                'icon'  =>  __('fi-rs-arrow-small-right', 'vankine-addons'),
                'list_item' =>  __('Marrige Insurance', 'vankine-addons'),
                'list_link' =>  __('#', 'vankine-addons'),
                ]
            ],
            'title_field' => '{{{ list_item }}}',
        ]
    );

    $this->add_responsive_control(
        'text_align',
        [
            'label' => esc_html__( 'Alignment', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'options' => [
                'left' => [
                    'title' => esc_html__( 'Left', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-left',
                ],
                'center' => [
                    'title' => esc_html__( 'Center', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-center',
                ],
                'right' => [
                    'title' => esc_html__( 'Right', 'vankine-addons' ),
                    'icon' => 'eicon-text-align-right',
                ],
            ],
            'default' => 'left',
            'toggle' => true,
            'selectors' => [
                '{{WRAPPER}} .list_box ' => 'text-align: {{VALUE}}!important;',
            ],
        ]
    );

    $this->end_controls_section();

    $this->start_controls_section('title_css',
    [ 
        'label' => __('Title Css', 'vankine-addons'),
        'tab' =>\Elementor\Controls_Manager::TAB_STYLE,
    ]
    );

    $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
            'label' => esc_html__( ' List Typography', 'vankine-addons' ),
            'name' => 'desc_typo',
            'selector' =>   '{{WRAPPER}} .list_box li a.links ', 
        ]
    );
     
    $this->add_control(
        'list_icon_color',
         [
            'label' => __('Icon Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .list_box li  i ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );

    $this->add_responsive_control(
        'icon_size_widths',
        [
            'label' => __('Icon / Image Size', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => 20,
            'min'     => 1,
            'max'     => 100,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .list_box li  i  , {{WRAPPER}} .list_box li img  ' => 'min-width: {{VALUE}}px!important; width: {{VALUE}}px!important; height:auto!important; font-size: {{VALUE}}px!important;', 
            ],
        ]
    );
    $this->add_responsive_control(
        'icon_top',
        [
            'label' => __('Icon Move Top', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' => 5,
            'min'     => -150,
            'max'     => 150,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .list_box li  i  , {{WRAPPER}} .list_box li img  ' => 'top: {{VALUE}}px!important; position:relative;', 
            ],
        ]
    );
    $this->add_responsive_control(
        'icon_right',
        [
            'label' => __('Icon Margin Right', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' =>  0,
            'min'     => -150,
            'max'     => 150,
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .list_box li  i  , {{WRAPPER}} .list_box li img  ' => 'margin-right: {{VALUE}}px!important;', 
            ],
        ]
    );
    $this->add_responsive_control(
        'rtlicon_right',
        [
            'label' => __('Icon Margin Left', 'vankine-addons'),
            'type'    => \Elementor\Controls_Manager::NUMBER,
            'default' =>  0,
            'min'     => -150,
            'max'     => 150, 
            'step'    => 1,
            'selectors' => [
                '{{WRAPPER}} .rtl .list_box li  i  , {{WRAPPER}} .rtl .list_box li img  ' => 'margin-left: {{VALUE}}px!important;', 
            ],
        ]
    );
    $this->add_responsive_control(
        'list_color',
         [
            'label' => __('List Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .list_box li a  ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_control(
        'list_hover_color',
         [
            'label' => __('List Hover Color', 'vankine-addons'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .list_box li:hover a ' => 'color: {{VALUE}}!important;',
            ],
         ]
    );
    $this->add_responsive_control(
        'list_margin',
        [
            'label' => esc_html__( 'List Margin', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .list_box li ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
    $this->add_responsive_control(
        'list_padding',
        [
            'label' => esc_html__( 'List Padding', 'vankine-addons' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'size_units' => [ 'px', '%', 'em' ],
            'selectors' => [
                '{{WRAPPER}} .list_box li ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}!important;',
            ],
        ]
    );
   
$this->end_controls_section();

}
protected function render(){
    $settings = $this->get_settings_for_display();
    $allowed_tags = wp_kses_allowed_html('post');  
?>
 
    <div class="position-relative">
    <ul class="list_box <?php echo esc_attr($settings['list_type']); ?>">
    <?php foreach($settings['list_repeater'] as  $key => $list_repeater):   
        $target = $list_repeater['list_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow = $list_repeater['list_link']['nofollow'] ? ' rel="nofollow"' : ''; ?>
        <li>
            <div class="d-flex align-items-center">
                    <?php if($list_repeater['icon_type'] == 'image'): ?>
                        <?php if(!empty($list_repeater['image']['url'])): ?>
                            <div class="icon">
                                <img src="<?php echo esc_url($list_repeater['image']['url']); ?>" alt="img" />
                            </div>
                        <?php endif; ?>
                    <?php elseif($list_repeater['icon_type'] == 'icon'): ?>
                       
                        <?php if($list_repeater['switcher_c_icon'] == 'yes'): ?>
                        <?php if(!empty($list_repeater['icon'])): ?>
                            <div class="icon trans">
                                <i class="<?php echo esc_attr($list_repeater['icon']); ?>"></i>
                            </div>
                        <?php endif; ?>	
                        <?php else: ?>
                                <?php if(!empty($list_repeater['icon_lib'])): ?>
                                    <div class="icon trans">
                                        <?php \Elementor\Icons_Manager::render_icon($list_repeater['icon_lib'], [ 'aria-hidden' => 'false' ]); ?>
                                    </div>
                                <?php endif; ?>	
                        <?php endif; ?>	
                
                    <?php endif; ?>
                <a class="links" href="<?php echo esc_url($list_repeater['list_link']['url']); ?>"  <?php echo esc_attr($target); ?> <?php echo esc_attr($nofollow); ?>>
                <?php echo wp_kses($list_repeater['list_item'] , $allowed_tags); ?>
                </a>
            </div>
        </li>
        <?php endforeach; ?>
    </ul>
    </div>
 
         <?php

    }
}

 